<?php

class LoggerFile extends Logger {
    private $log_fileinfo;

    public function __construct($log_fileinfo) {
        $this->log_fileinfo = $log_fileinfo;
    }

    public function debug($message){ $this->log_line('DEBUG', $message); }
    public function info($message){ $this->log_line('INFO', $message); }
    public function warn($message){ $this->log_line('WARN', $message); }
    public function error($message){ $this->log_line('ERROR', $message); }
    public function fatal($message){ $this->log_line('FATAL', $message); }

    private function log_line($level, $message) {
        $full_message = date('Y-m-d H:i:s').' ['.getmypid().'] ';
        $full_message .= $level.' - '.$message."\n";

        $file = $this->log_fileinfo->openFile('a');
        $file->fwrite($full_message);
    }
}
