<?php
/*

  Plugin Name: Verotel/CardBilling FlexPay for WooCommerce
  Plugin URI: http://www.verotel.com/en/index.html?lang=en
  Description: Pay with card using Verotel or CardBilling service.
  Author: Ivan Merxbauer
  Version: 1.0
  Author URI: http://www.verotel.com/en/index.html?lang=en
 */
/**
 * Provides a Verotel / CardBilling Gateway.
 *
 * @class 		WC_Gateway_FlexPay
 * @extends		WC_Payment_Gateway
 * @version		1.0
 * @package		Verotel
 * @author 		Ivan Merxbauer
 */
add_action('plugins_loaded', 'init_Plugin');

require_once __DIR__ . '/includes/src/Verotel/FlexPay/Client.php';

function init_Plugin() {

    class WC_Gateway_FlexPay extends WC_Payment_Gateway {

        private $allowed_currencies = array("USD", "EUR", "GBP", "AUD", "CAD", "CHF", "DKK", "NOK", "SEK");

        public function __construct() {
            $success_url = get_option('siteurl') . "/index.php/checkout/order-received";
            $postback_url = get_option('siteurl') . "/?wc-api=callback";
            $this->id = 'verotel';
            $this->icon = 'http://www.verotel.com/images.v2/logos.png';
            $this->title = 'Verotel / CardBilling FlexPay';
            $this->method_title = "Verotel / CardBilling FlexPay";
            $this->method_description = "Verotel / CardBilling plugin enables your customers to pay with credit card, using Verotel / CardBilling gateway.<br><br>"
                    . "Control Center Setup:<br>"
                    . "- Set the 'Flexpay postback script URL' in your Control Center to: <strong>" . htmlspecialchars($postback_url) . "</strong><br>"
                    . "- 'Flexpay success URL' is not used and can be left empty.";
            $this->init_form_fields();
            $this->init_settings();
            if (is_admin()) {
                add_action('woocommerce_update_options_payment_gateways_' . $this->id, array(
                    $this,
                    'process_admin_options'
                ));
            }

            foreach ($this->settings as $setting_key => $value) {
                $this->$setting_key = $value;
            }

            add_action('woocommerce_api_callback', array(
                $this,
                'postback_handler'
            ));
            add_action("admin_notices", array($this, validate_eshop_currency));
            $this->checkInputs();
        }

        public function validate_eshop_currency() {
            if (isset($_POST['woocommerce_currency'])) {

                update_option('woocommerce_currency', $_POST['woocommerce_currency']);
                update_option("bad_currency", "no");
            }
            if (!in_array(get_option("woocommerce_currency"), $this->allowed_currencies)) {
                update_option("bad_currency", "yes");
                $this->enabled = "no";
                ?>
                <div class="error notice">
                    <p><strong>
                            <?php
                            _e('Gateway Disabled', 'woocommerce');
                            ?></strong>:
                        <?php
                        _e("Payment with this currency is not available if you want to use Verotel / CardBilling Gateway,"
                                . " please choose a different one (" . join(", ", $this->allowed_currencies) . ").", 'wuucommerce');
                        ?>

                    </p>
                </div>
                <?php
            }
        }
        public function checkInputSpaces($name){
            if(trim($name) == ''){
                return false;
            }
            return true;
        }
        // udělat kontrolu spaces
        public function checkInputs() {
            if (isset($_POST['woocommerce_verotel_signature'])) {
                if($this->checkInputSpaces($_POST['woocommerce_verotel_signature'])){
                     update_option("signature_fill", $_POST['woocommerce_verotel_signature']);
                     update_option("enabled_fill", $_POST['woocommerce_verotel_enabled']);
                }else{
                    update_option("signature_fill", false);
                    update_option("enabled_fill", $_POST['woocommerce_verotel_enabled']);
                }
            }
            if (isset($_POST['woocommerce_verotel_shopID'])) {
                if($this->checkInputSpaces($_POST['woocommerce_verotel_shopID'])){
                    update_option("shopid_fill", $_POST['woocommerce_verotel_shopID']);
                    update_option("enabled_fill", $_POST['woocommerce_verotel_enabled']);
                }else{
                    update_option("shopid_fill", false);
                    update_option("enabled_fill", $_POST['woocommerce_verotel_enabled']);
                }
            }
            if (isset($_POST['woocommerce_verotel_merchantID'])) {
                if($this->checkInputSpaces($_POST['woocommerce_verotel_merchantID'])){
                    update_option("merchantid_fill", $_POST['woocommerce_verotel_merchantID']);
                    update_option("enabled_fill", $_POST['woocommerce_verotel_enabled']);
                }else{
                    update_option("merchantid_fill", false);
                    update_option("enabled_fill", $_POST['woocommerce_verotel_enabled']);
                }
            }
            if (!get_option("signature_fill")) {
                update_option("signature_fill", "empty");
            }
            if (!get_option("shopid_fill")) {
                update_option("shopid_fill", "empty");
            }
            if (!get_option("merchantid_fill")) {
                update_option("merchantid_fill", "empty");
            }
            if (!get_option("enabled_fill")) {
                update_option("enabled_fill", "empty");
            }
            if (get_option("enabled_fill") === "1") {
                if (get_option("signature_fill") == "empty" OR get_option("shopid_fill") == "empty" OR get_option("merchantid_fill") == "empty") {
                    add_action("admin_notices", array($this, "input_error_notice"));
                    $this->enabled = "no";
                }
            }
        }

        public function getFlexPayClient() {
            $brand = Verotel\FlexPay\Brand::create_from_merchant_id($this->merchantID);

            return new Verotel\FlexPay\Client($this->shopID, $this->signature, $brand);
        }

        /* resolve type of postback, only complete payment on success callback */

        public function postback_handler() {
            $flexpayClient = $this->getFlexPayClient();
            if ($flexpayClient->validate_signature($_GET)) {
                echo "OK";
                $order = new WC_Order($_GET['referenceID']);
                $order->payment_complete();
                exit;
            } else {
                echo "ERROR";
                exit;
            }
        }

        public function input_error_notice() {
            if (get_option("bad_currency") === "no") {
                $messages = [];
                $input_message1 = "Please fill the following inputs:";
                ?>
                <div class="error notice">
                    <p>
                        <?php
                        if (get_option("signature_fill") == "empty") {
                            $messages[]= "Signature Key";
                        }
                        if (get_option("shopid_fill") == "empty") {
                            $messages[]= "Shop ID";
                        }
                        if (get_option("merchantid_fill") == "empty") {
                            $messages[]= "Merchant ID";
                        }
                        $input_message2 .= " otherwise the Verotel/CardBilling Gateway would not be available for payments (change settings <a href='" . get_option('siteurl') . "/wp-admin/admin.php?page=wc-settings&tab=checkout&section=verotel'>here</a>)";
                        $final_input_message= $input_message1 . " " . implode(", ",$messages).$input_message2;
                        echo $final_input_message;
                        ?>
                    </p>
                </div>
                <?php
            }
        }

        public function init_form_fields() {
            $this->form_fields = include('includes/settings.php');
        }

        function process_payment($order_id) {
            global $woocommerce;
            $order = new WC_Order($order_id);

            $order->update_status('on-hold', __('Waiting for payment', 'woocommerce'));

            $order->reduce_order_stock();

            $woocommerce->cart->empty_cart();

            return array(
                'result' => 'success',
                'redirect' => $this->get_return_url($order)
            );
        }

        function get_return_url($order = NULL) {
            $url = parent::get_return_url($order);
            if ($order === NULL) {
                return $url;
            }
            $params = array(
                "priceAmount" => $order->order_total,
                "priceCurrency" => get_woocommerce_currency(),
                "description" => "Payment for order # " . $order->id . " on " . get_option('siteurl'),
                "email" => $order->billing_email,
                "type" => 'purchase',
                "referenceID" => $order->id,
                "origin" => "Woocommerce WP plugin 1.0",
            );

            $order = new WC_Order($order->id);
            $order_key = $order->order_key;
            $params['backURL'] = $order->get_checkout_order_received_url();
            $flexpayClient = $this->getFlexPayClient();
            $purchaseUrl = $flexpayClient->get_purchase_URL($params);
            return $purchaseUrl;
        }

    }

}

function add_FlexPay($methods) {
    $methods[] = 'WC_Gateway_FlexPay';
    return $methods;
}

add_filter('woocommerce_payment_gateways', 'add_FlexPay');
