<?php

class StorageHtpasswd extends ProcessInterface {
    private $htpasswd_fileinfo;
    private $temp_fileinfo;
    private $lock_fileinfo;
    private $rename_call;

    public function __construct(
        $htpasswd_fileinfo, $temp_fileinfo, $lock_fileinfo, $rename_call = 'rename'
    ) {
        $this->htpasswd_fileinfo = $htpasswd_fileinfo;
        $this->temp_fileinfo = $temp_fileinfo;
        $this->lock_fileinfo = $lock_fileinfo;
        $this->rename_call = $rename_call;
    }

    public function add($usercode, $passcode, $amount){
        $lock = $this->get_lock();

        if ($this->htpasswd_fileinfo->isFile()){
            $file = $this->htpasswd_fileinfo->openFile('r');
            while (!$file->eof()){
                $line = $file->fgets();
                if ($this->is_line_with_usercode($line, $usercode)){
                    throw new ExceptionRUMDecline("user '$usercode' already exists");
                }
            }
        }

        $file = $this->htpasswd_fileinfo->openFile('a');
        $file->fwrite("$usercode:$passcode\n");
    }

    public function modify($usercode, $passcode){
        $lock = $this->get_lock();
        $this->delete_usercode_line($usercode);
        $file = $this->htpasswd_fileinfo->openFile('a');
        $file->fwrite("$usercode:$passcode\n");
    }

    public function delete($usercode){
        $lock = $this->get_lock();
        $this->delete_usercode_line($usercode);
    }

    private function get_lock(){
        return new FileLock($this->lock_fileinfo);
    }

    private function is_line_with_usercode( $line, $usercode ){
        $parts = explode(':', $line, 2);
        if ($parts[0] == $usercode){
            return true;
        }
        return false;
    }

    private function delete_usercode_line( $usercode ){
        if (!$this->htpasswd_fileinfo->isFile()){
            throw new ExceptionRUMDecline("user '$usercode' doesn't exist");
        }

        $user_found = false;

        $file = $this->htpasswd_fileinfo->openFile('r');
        while (!$file->eof()){
            $line = $file->fgets();
            if ($this->is_line_with_usercode($line, $usercode)){
                $user_found = true;
                break;
            }
        }

        if (!$user_found){
            throw new ExceptionRUMDecline("user '$usercode' doesn't exist");
        }

        $file->rewind();

        $temp_file = $this->temp_fileinfo->openFile('w');

        while (!$file->eof()){
            $line = $file->fgets();
            if ($this->is_line_with_usercode($line, $usercode)){
                continue;
            }
            $temp_file->fwrite($line);
        }

        $file = null;
        $temp_file = null;

        $this->rename_temp();
    }

    private function rename_temp(){
        $rename = $this->rename_call;
        $rename($this->temp_fileinfo->getRealPath(),
            $this->htpasswd_fileinfo->getRealPath());
    }
}
