<?php

/*
Copyright (C) 2014 Verotel IT Services

This script uses Verotel RUM Protocol version 1.1

DESCRIPTION

This script handles access account management (adding, modifying, deleting) for
Apache web server. User accounts are stored in ".htpasswd" file.

New user accounts are created with "add" call. User's password is encrypted
before it's sent over the Internet. If your server is unreachable at the time of
"add" call, Verotel will go on trying to add the account for another half an
hour. If new account cannot be created within 30 minutes after customer was
charged, Verotel will refund the customer and notify both web-master and
customer by email.

"add" call will contain following data: usercode, passcode (encrypted),
transaction amount (in USD) and optionally Verotel unique transaction number.

Web-master can change password of existing users in Verotel Control Center. In
this case "modify" call is issued. It contains usercode and encrypted password.

User accounts are removed from system by "delete" call. This call only contains
usercode.

Users can indicate they don't want their recurring subscriptions to be re-billed
again. Once they do so (by visiting http://cancel.verotel.com), Verotel will
issue "cancel" call containing usercode. No functionality is provided in this
script for "cancel" by default, it's safe to ignore this call. Should you need
some functionality tied to this event, you're free to fill in your own custom
code.

Every time a recurring subscription is re-billed, Verotel will issue "rebill"
call.  This call will contain usercode, transaction amount (in USD) and unique
transaction number. Again, the default "rebill" handler is empty and can be
safely ignored, but you're free to fill in custom code.

INSTALLATION

1. Copy all content of the "script" directory in the distribution file to your
website.

2. The password file ".htpasswd" will be stored in so-called data directory
on your website. Either use already existing directory or create a new one and
set permissions on this directory.

  $ mkdir /full/path/to/your_data_dir
  $ chmod 770 /full/path/to/your_data_dir

3. Copy all files from "data" directory in the distribution file to your newly
created data directory.

  $ cp data/* data/.* /full/path/to/your_data_dir

4. Edit the script and change value of $DATA_DIRECTORY variable to the name of your
data directory (including full path).

5. [Optional] You can modify other variables in the configuration area to better
suit your needs.

6. Modify ".htaccess" file in protected area of your website. This file
specifies location of your password file. It should contain line like

  AuthUserFile /full/path/to/your_data_dir/.htpasswd

7. Visit Verotel Control Center and test your RUM setup by trying to add user
account. Check that the added test user account allows you to access protected
area of your website. Try to delete this user account and check access to the
protected area isn't possible for this user anymore.

8. If your RUM setup works fine, please submit a test request so a Verotel
Engineer can test your installation. If your RUM setup doesn't work, please
submit an installation request, and a Verotel Engineer will perform the
installation for you at no cost.

CONFIGURATION

Keep the configuration files in directories invisible to users browsing your
website. The actual physical location of the files doesn't matter as long as
ordinary users don't have access to them.

$DATA_DIRECTORY

This is the data directory which contains the password file, log file and other
supporting files.

Replace default value with full path to data directory on your
website. To prevent ordinary users from accessing the directory and files
inside, you should set proper file permissions on them.

  $ chmod 770 /full/path/to/your_data_dir

*/
$DATA_DIRECTORY = '/full/path/to/your_data_dir';


$HTPASSWD_FILEINFO = new SplFileInfo($DATA_DIRECTORY.'/.htpasswd');
$TEMP_FILEINFO = new SplFileInfo($DATA_DIRECTORY.'/.htpasswd.tmp');
$LOG_FILEINFO = new SplFileInfo($DATA_DIRECTORY.'/verotel_RUM.log');
$IP_LIST_FILEINFO = new SplFileInfo($DATA_DIRECTORY.'/.ht_IP_addresses');

$LOCK_FILEINFO = new SplFileInfo($DATA_DIRECTORY.'/.htlock');

spl_autoload_register(function($className) {
    require_once('VerotelRUMlib/'.$className.'.php'); });

$rum_client = new Client(
    new LoggerFile($LOG_FILEINFO),
    new StorageHtpasswd($HTPASSWD_FILEINFO, $TEMP_FILEINFO, $LOCK_FILEINFO),
    new FileIPList($IP_LIST_FILEINFO)
);

header('Content-type: text/plain');
print $rum_client->process($_POST);
